   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.30  10/19/06            */
   /*                                                     */
   /*              RETE UTILITY HEADER FILE               */
   /*******************************************************/

/*************************************************************/
/* Purpose: Provides a set of utility functions useful to    */
/*   other modules.                                          */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.24: Rule with exists CE has incorrect activation.  */
/*            DR0867                                         */
/*                                                           */
/*      6.30: Added support for hashed alpha memories.       */
/*                                                           */
/*************************************************************/

#ifndef _H_reteutil
#define _H_reteutil

#ifndef _H_evaluatn
#include "evaluatn.h"
#endif
#ifndef _H_match
#include "match.h"
#endif
#ifndef _H_network
#include "network.h"
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _RETEUTIL_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

   LOCALE void                           PrintPartialMatch(void *,char *,struct partialMatch *);
   LOCALE struct partialMatch           *CopyPartialMatch(void *,struct partialMatch *,int,int);
   LOCALE struct partialMatch           *MergePartialMatches(void *,struct partialMatch *,struct partialMatch *,int,int);
   LOCALE struct partialMatch           *AddSingleMatch(void *,struct partialMatch *,struct alphaMatch *,int,int);
   LOCALE struct partialMatch           *AddNotMatch(void *,struct partialMatch *,int,int);
   LOCALE struct partialMatch           *NewPseudoFactPartialMatch(void *);
   LOCALE long int                       IncrementPseudoFactIndex(void);
   LOCALE struct partialMatch           *GetAlphaMemory(void *,struct patternNodeHeader *,unsigned long);
   LOCALE void                           RemoveAlphaMemoryMatches(void *,struct patternNodeHeader *,struct partialMatch *,struct alphaMatch *,unsigned long); 
   LOCALE void                           DestroyAlphaMemory(void *,struct patternNodeHeader *,int);
   LOCALE void                           FlushAlphaMemory(void *,struct patternNodeHeader *);
   LOCALE void                           InitializeAlphaMemory(struct patternNodeHeader *theHeader);
   LOCALE void                           FlushAlphaBetaMemory(void *,struct partialMatch *);
   LOCALE void                           DestroyAlphaBetaMemory(void *,struct partialMatch *);
   LOCALE int                            GetPatternNumberFromJoin(struct joinNode *);
   LOCALE struct multifieldMarker       *CopyMultifieldMarkers(void *,struct multifieldMarker *);
   LOCALE struct partialMatch           *CreateAlphaMatch(void *,void *,struct multifieldMarker *,
                                                          struct patternNodeHeader *,unsigned long);
   LOCALE void                           TraceErrorToRule(void *,struct joinNode *,char *);
   LOCALE void                           InitializePatternHeader(void *,struct patternNodeHeader *);
   LOCALE void                           MarkRuleNetwork(void *,int);
   LOCALE void                           TagRuleNetwork(void *,long *,long *,long *);
   LOCALE int                            FindEntityInPartialMatch(struct patternEntity *,struct partialMatch *);
   LOCALE unsigned long                  ComputeRightHashValue(void *,struct patternNodeHeader *);
   LOCALE void                           UpdatePMLinks(struct partialMatch *,struct partialMatch *,struct partialMatch *,struct joinNode *,intBool);
   LOCALE void                           UnlinkBetaPMFromNodeAndLineage(struct joinNode *,struct partialMatch *,intBool);
   LOCALE void                           UpdatePMAlphaLinks(struct partialMatch *,struct partialMatch *);
   LOCALE void                           UnlinkBetaPMFromRight(struct partialMatch *);
   LOCALE int                            PartialMatchInvalid(struct partialMatch *);   
   LOCALE void                           UnlinkBetaPMFromNode(struct joinNode *,struct partialMatch *,intBool);
   LOCALE void                           LinkBetaPMToNode(struct joinNode *,struct partialMatch *,intBool);
   
#endif




